/*================================ Header ==============================*/

const headerSection = document.querySelector("header");
function updateHeaderHeight() {
  const root = document.querySelector(":root");
  root.style.setProperty("--headerHeight", headerSection.offsetHeight + "px");
}

window.addEventListener("load", updateHeaderHeight);
window.addEventListener("resize", updateHeaderHeight);

/*================================ FAQ Accordion ==============================*/

const faqAccordion = document.querySelectorAll(".faq-item");

faqAccordion.forEach((element) => {
  element.addEventListener("click", openFAQAccordion);
});

function openFAQAccordion(event) {
  event.preventDefault();
  event.target.parentElement.classList.toggle("faq-item-open");
}

/*========================== Read More Description =========================*/

// For Open And Collapse Description
function moreOrLess(e) {
  let description = e.target.previousElementSibling;
  description.classList.toggle("all-description");
  // Change Button Text
  if (description.classList.contains("all-description")) {
    e.target.innerHTML = "نمایش کمتر";
  } else {
    e.target.innerHTML = "نمایش بیشتر";
  }
}
/*================================ Scroll Up ==============================*/

const scrollButton = document.getElementById("scrollToTop");

scrollButton.onclick = () => {
  document.body.scrollTop = 0;
  document.documentElement.scrollTop = 0;
};
window.onscroll = () => {
  if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
    scrollButton.style.visibility = "visible";
    scrollButton.style.opacity = "1";
    headerSection.classList.add("scrolled");
  } else {
    scrollButton.style.visibility = "hidden";
    scrollButton.style.opacity = "0";
    headerSection.classList.remove("scrolled");
  }
};

/*================================ Mobile Menu Accordion ==============================*/

// const mobileNavigationAccordion = document.querySelectorAll(".mobile-navigation-accordion-button");

// mobileNavigationAccordion.forEach((element) => {
//   element.addEventListener("click", openAccordion);
// });

// function openAccordion(event) {
//   event.preventDefault();
//   event.target.parentElement.parentElement.classList.toggle("open-mobile-navigation-accordion");
// }

/*================================= Counter Box =================================*/

// For Count The Numbers Of Counter Boxes
if (document.querySelectorAll(".counter-value").length) {
  const targetElement = document.querySelector(".counters-list");
  let isCounting = false;

  document.addEventListener("scroll", function (e) {
    const bounding = targetElement.getBoundingClientRect();

    if (bounding.top >= 0 && bounding.left >= 0 && bounding.right <= (window.innerWidth || document.documentElement.clientWidth) && bounding.bottom <= (window.innerHeight || document.documentElement.clientHeight)) {
      if (!isCounting) {
        // Select Elements
        const array = Array.from(document.querySelectorAll(".counter-value"));
        // Select Array Element
        array.map((item) => {
          let targetNumber = Number(item.textContent);
          let duration = 2000;
          let increment = targetNumber / (duration / 20); // 20ms is the interval step
          let currentNumber = 0;

          function counterUp() {
            currentNumber += increment;
            if (currentNumber >= targetNumber) {
              item.textContent = targetNumber;
              clearInterval(stop);
            } else {
              item.textContent = Math.floor(currentNumber);
            }
          }
          // Update every 20ms
          const stop = setInterval(counterUp, 20);
        });
        isCounting = true;
      }
    }
  });
}

/**========================================================================
 *                                     Switch Y
 *========================================================================**/

function switchTab(e) {
  document.querySelectorAll(".tab-pane").forEach((e) => {
    e.classList.remove("show", "active");
  });
  const t = document.getElementById(e);
  t && t.classList.add("show", "active");

  const buttons = document.querySelectorAll(".nav-link");
  buttons.forEach((btn) => btn.classList.remove("active"));

  const currentButton = event.currentTarget;
  currentButton.classList.add("active");
}
/*================================ Footer ==============================*/

// if (window.innerWidth < 1024) {
//   document.querySelectorAll(".footer-heading").forEach(heading => {
//     heading.addEventListener("click", () => {
//       const dropdown = heading.nextElementSibling;
//       if (dropdown) {
//         dropdown.style.display = dropdown.style.display === "block" ? "none" : "block";
//       }
//     });
//   });
// }

/*================================ Product Images Zoom ==============================*/

// document.addEventListener("DOMContentLoaded", function () {
//   var images = document.querySelectorAll(".product-image");
//   images.forEach(function (image) {
//     blowup(image, {
//       width: 300,
//       height: 300,
//       scale: 2,
//       background: "transparent",
//       border: "3px solid var(--primaryColor)",
//       round: true,
//       shadow: "none",
//       customClasses: "zoom-box",
//     });
//   });
// });

/*=================================== Tooltip =======================*/
var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
  return new bootstrap.Tooltip(tooltipTriggerEl);
});
// ====================================== Navbar hover ================
// document.addEventListener("DOMContentLoaded", function () {
//   const links = document.querySelectorAll(".nav-link");
//   const indicator = document.getElementById("hover-indicator");

//   links.forEach((link) => {
//     link.addEventListener("mouseenter", () => {
//       const linkRect = link.getBoundingClientRect();
//       const navRect = link.closest(".header-bottom-side").getBoundingClientRect();

//       const offsetLeft = linkRect.left - navRect.left + linkRect.width / 2;

//       indicator.style.left = `${offsetLeft}px`;
//       indicator.style.opacity = 1;
//     });

//     link.addEventListener("mouseleave", () => {
//       indicator.style.opacity = 0;
//     });
//   });
// });

/*=================================== Mobile Menu =======================*/
function toggleMobileMenu() {
  const menu = document.getElementById("mobileMenu");
  const overlay = document.getElementById("menuOverlay");
  const isOpen = menu.classList.contains("active");

  if (isOpen) {
    menu.classList.remove("active");
    overlay.classList.remove("active");
  } else {
    menu.classList.add("active");
    overlay.classList.add("active");
  }
}



// ============================ Aticle Page =================================
